/*******************************************************************************
  moveRam.C:  This is used by tagTest.c to define functions associated with a
  moveable block of RAM.  Once a moveable block of RAM is chosen, functions
  described by this header file must be provided for that particular RAM.
  
  The RAM implementation is kept separate because there are several ways under
  discussion for how to deploy this test.  A board in the field would probably
  want to use KRAM for this field (cached by virtue of accessing it through 
  the back-door path.  The tester, on the other hand, wants to keep vector 
  depth down by putting code in KRAM.
*******************************************************************************/
#include "src/init/m5282evb.h"
#include "environment.h"
#include "moveRam.h"


int moveRam (UINT32 * baseAddr)
{
	 // the base address of the RAM is moved to here: baseAddr
	 // returns nonzero (true) if the function succeeds, false if it fails.
	
	MCF5282_SCM_RAMBAR = ((vuint32)baseAddr & 0xFFFF0000) + 0x200;
	
	return 0;
}
